<?php

if (!defined('IN_SITE')) {
    die('The Request Not Found');
}




$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();

if (isSecureCookie('admin_login') != true) {
    redirect(base_url('client/logout'));
} else {
    // Validate và sử dụng prepared statement an toàn
    $admin_token = validate_alphanumeric($_COOKIE['admin_login'], 255);
    if ($admin_token === false) {
        checkBlockIP('ADMIN', 5);
        redirect(base_url('client/logout'));
    }
    $getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? AND `admin` > 0", [$admin_token]);
    // chuyển hướng đăng nhập khi thông tin login không tồn tại
    if (!$getUser) {
        // Rate limit
        checkBlockIP('ADMIN', 5);
        redirect(base_url('client/logout'));
    }
    // Khác thiết bị khi login thì đăng xuất
    // if ($_COOKIE['user_agent'] != $Mobile_Detect->getUserAgent()){
    //     redirect(base_url('client/logout'));
    // }
    if ($getUser['device'] != $Mobile_Detect->getUserAgent()){
        redirect(base_url('client/logout'));
    }
    // chuyển hướng khi bị khoá tài khoản
    if ($getUser['banned'] != 0) {
        redirect(base_url('common/banned'));
    }
    if($getUser['admin'] <= 0){
        // Rate limit
        checkBlockIP('ADMIN', 5);
        redirect(base_url('client/logout'));
    }
    // khoá tài khoản trường hợp âm tiền, tránh bug
    if ($getUser['money'] < 0) {
        $User = new users();
        $User->Banned($getUser['id'], 'Tài khoản âm tiền, ghi vấn bug');
        redirect(base_url('common/banned'));
    }
    // kiểm tra ip có trong whitelist
    if($CMSNT->site('status_security') == 1){
        // Validate IP trước khi kiểm tra whitelist
        $current_ip = validate_ip(myip());
        if ($current_ip === false || !$CMSNT->get_row_safe("SELECT * FROM `ip_white` WHERE `ip` = ?", [$current_ip])){
            redirect(base_url('common/block'));
        }
    }
    if($CMSNT->site('status_only_ip_login_admin') == 1){
        // Validate IP và user ID trước khi so sánh
        $current_ip = validate_ip(myip());
        $user_id = validate_int($getUser['id'], 1);
        if ($current_ip !== false && $user_id !== false && $getUser['ip'] != $current_ip){
            $token = md5(random('QWERTYUIOPASDGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm0123456789', 32).uniqid());
            $CMSNT->update('users', [
                'token'     => $token
            ], " `id` = ?", [$user_id]);
            redirect(base_url('client/logout'));
        }
    }

    // Xóa IP bị đánh dấu ra - Validate IP trước khi xóa
    $current_ip = validate_ip(myip());
    if ($current_ip !== false) {
        $CMSNT->remove('failed_attempts', " `ip_address` = ?", [$current_ip]);
    }

    /* cập nhật thời gian online */
    // Validate user ID và IP trước khi update
    $user_id = validate_int($getUser['id'], 1);
    $user_ip = validate_ip(myip());
    if ($user_id !== false && $user_ip !== false) {
        $CMSNT->update("users", [
            'update_date'   => gettime(),
            'ip'            => $user_ip
        ], " `id` = ?", [$user_id]);
    }
}

 