<?php

if (!defined('IN_SITE')) {
    die('The Request Not Found');
}

// chọn ngôn ngữ
function setLanguage($id)
{
    global $CMSNT;
    
    // Validate input - chỉ chấp nhận số nguyên dương
    $validated_id = validate_int($id, 1);
    if ($validated_id === false) {
        return false;
    }
    
    // Sử dụng prepared statement để tránh SQL injection
    if ($row = $CMSNT->get_row_safe("SELECT * FROM `languages` WHERE `id` = ? AND `status` = 1", [$validated_id])) {
        $isSet = setcookie('language', $row['lang'], time() + (31536000 * 30), "/"); // 31536000 = 365 ngày
        if ($isSet) {
            return true;
        } else {
            return false;
        }
    }
    return false;
}

// lấy ngôn ngữ mặc định
function getLanguage()
{
    global $CMSNT;
    if (isset($_COOKIE['language'])) {
        // Validate cookie value - chỉ chấp nhận alphanumeric và dấu gạch ngang
        $language = validate_alphanumeric($_COOKIE['language'], 10);
        if ($language !== false) {
            // Sử dụng prepared statement để tránh SQL injection
            $rowLang = $CMSNT->get_row_safe("SELECT * FROM `languages` WHERE `lang` = ? AND `status` = 1", [$language]);
            if ($rowLang) {
                return $rowLang['lang'];
            }
        }
    }
    // Lấy ngôn ngữ mặc định - không cần prepared statement vì không có user input
    $rowLang = $CMSNT->get_row("SELECT * FROM `languages` WHERE `lang_default` = 1");
    if ($rowLang) {
        return $rowLang['lang'];
    }
    return false;
}
//hiển thị ngôn ngữ
function __($name)
{
    global $CMSNT;
    if (isset($_COOKIE['language'])) {
        // Validate cookie value
        $language = validate_alphanumeric($_COOKIE['language'], 10);
        if ($language !== false) {
            // Sử dụng prepared statement để tránh SQL injection
            $rowLang = $CMSNT->get_row_safe("SELECT * FROM `languages` WHERE `lang` = ? AND `status` = 1", [$language]);
            if ($rowLang) {
                // Sử dụng prepared statement cho translate query
                $rowTran = $CMSNT->get_row_safe("SELECT * FROM `translate` WHERE `lang_id` = ? AND `name` = ?", [$rowLang['id'], $name]);
                if ($rowTran) {
                    return $rowTran['value'];
                }
            }
        }
    }
    
    // Lấy ngôn ngữ mặc định
    $rowLang = $CMSNT->get_row("SELECT * FROM `languages` WHERE `lang_default` = 1");
    if ($rowLang) {
        // Sử dụng prepared statement cho translate query với ngôn ngữ mặc định
        $rowTran = $CMSNT->get_row_safe("SELECT * FROM `translate` WHERE `lang_id` = ? AND `name` = ?", [$rowLang['id'], $name]);
        if ($rowTran) {
            return $rowTran['value'];
        }
    }
    return $name;
}

