<?php

define("IN_SITE", true);
require_once(__DIR__."/../libs/db.php");
require_once(__DIR__."/../config.php");
require_once(__DIR__."/../libs/lang.php");
require_once(__DIR__."/../libs/helper.php");
require_once(__DIR__."/../libs/database/users.php");
$CMSNT = new DB();


// Validate username từ GET hoặc POST
if(isset($_GET['username'])){
    $username = validate_string($_GET['username'], 50);
} else if(isset($_POST['username'])){
    $username = validate_string($_POST['username'], 50);
} else{
    $username = false;
}

// Validate password từ GET hoặc POST
if(isset($_GET['password'])){
    $password = validate_string($_GET['password'], 255, 1);
} else if(isset($_POST['password'])){
    $password = validate_string($_POST['password'], 255, 1);
} else{
    $password = false;
}


if ($username !== false && $password !== false) {
    if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `username` = ?", [$username])) { 
        die(json_encode(['status' => 'error', 'msg' => __('Thông tin đăng nhập không chính xác')]));
    }
    if($getUser['banned'] == 1){
        die(json_encode(['status' => 'error', 'msg' => __('Tài khoản của bạn đã bị cấm truy cập')]));
    }
    if(in_array(myip(), $ip_server_black)) {
        die(__('Chức năng này không hỗ trợ cho web dùng crack'));
    }
    if ($CMSNT->site('type_password') == 'bcrypt') {
        if (!password_verify($password, $getUser['password'])) {
            // Rate limit
            checkBlockIP('API', 5);
            if($getUser['login_attempts'] >= $config['limit_block_login_client']){
                $User = new users();
                $User->Banned($getUser['id'], __('Đăng nhập thất bại nhiều lần'));
                die(json_encode(['status' => 'error', 'msg' => __('Tài khoản của bạn đã bị tạm khoá do đang nhập sai nhiều lần')]));
            }
            $CMSNT->cong('users', 'login_attempts', 1, " `id` = ? ", [$getUser['id']]);
            die(json_encode(['status' => 'error', 'msg' => __('Thông tin đăng nhập không chính xác')]));
        }
    } else {
        if ($getUser['password'] != TypePassword($password)) {
            // Rate limit
            checkBlockIP('API', 5);
             
            if($getUser['login_attempts'] >= $config['limit_block_login_client']){
                $User = new users();
                $User->Banned($getUser['id'], __('Đăng nhập thất bại nhiều lần'));
                die(json_encode(['status' => 'error', 'msg' => __('Tài khoản của bạn đã bị tạm khoá do đang nhập sai nhiều lần')]));
            }
            $CMSNT->cong('users', 'login_attempts', 1, " `id` = ? ", [$getUser['id']]);
            die(json_encode(['status' => 'error', 'msg' => __('Thông tin đăng nhập không chính xác')]));
        }
    }
    if($CMSNT->site('status_api_buyproduct') == 0){
        die(__('Chức năng kết nối API đã được tắt trên website này'));
    }
    if ($money = $getUser['money']) {
        die(format_currency($money));
    } else {
        die(format_currency(0));
    }
}



