<?php

define("IN_SITE", true);
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/lang.php");
require_once(__DIR__."/../../libs/helper.php");
$CMSNT = new DB();
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Validate store type with whitelist
    $store = validate_string($_POST['store'], 50);
    if ($store === false || !in_array($store, ['mua-xu-ttc', 'mua-xu-tds', 'otp-order', 'order-service', 'accounts', 'documents', 'store-fanpage'])) {
        die(format_currency(0));
    }

    if($store == 'mua-xu-ttc'){
        if (empty($_POST['amount'])) {
            die(format_currency(0));
        }
        $amount = validate_float($_POST['amount'], 0.01);
        if ($amount === false) {
            die(format_currency(0));
        }
        $total = $amount * $CMSNT->site('rate_ban_xu_ttc');
        die(format_currency($total));
    }
    if($store == 'mua-xu-tds'){
        if (empty($_POST['amount'])) {
            die(format_currency(0));
        }
        $amount = validate_float($_POST['amount'], 0.01);
        if ($amount === false) {
            die(format_currency(0));
        }
        $total = $amount * $CMSNT->site('rate_ban_xu_tds');
        die(format_currency($total));
    }
    
    if($store == 'otp-order'){
        if (empty($_POST['amount'])) {
            die(format_currency(0));
        }
        
        // Validate token
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(__('Vui lòng đăng nhập'));
        }
        
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ?", [$token])) {
            die(__('Vui lòng đăng nhập'));
        }
        
        // Validate service ID
        $service_id = validate_int($_POST['id'], 1);
        if ($service_id === false) {
            die(format_currency(0));
        }
        
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `service_otp` WHERE `id` = ?", [$service_id])) {
            $amount = validate_float($_POST['amount'], 0.01);
            if ($amount === false) {
                die(format_currency(0));
            }
            $total = $amount * $row['price'];
            // $total = $total - $total * $getUser['chietkhau'] / 100;
            die(format_currency($total));
        }
        die(format_currency(0));
    }


    if($store == 'order-service'){
        if(empty($_POST['service'])){
            die(json_encode([
                'status' => 'success',
                'type'  => '',
                'total' => format_currency(0),
                'msg'   => ''
            ]));
        }
        
        // Validate service ID
        $service_id = validate_int($_POST['service'], 1);
        if ($service_id === false) {
            die(json_encode([
                'status' => 'error',
                'total' => format_currency(0),
                'msg'   => 'Invalid service ID'
            ]));
        }
        
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `services` WHERE `id` = ?", [$service_id])) {
            $ck = 0; // Default discount
            if(isset($_POST['token'])){
                $token = validate_alphanumeric($_POST['token']);
                if($token !== false){
                    if($getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? AND `banned` = 0", [$token])){
                        $ck = $getUser['chietkhau'];
                    }
                }
            }
            
            $amount = validate_float($_POST['amount'], 0.01);
            if ($amount === false) {
                $amount = 0;
            }
            
            if($row['type'] == 'Custom Comments'){
                if(isset($_POST['comment'])) {
                    $comment = validate_string($_POST['comment'], 5000);
                    if ($comment !== false) {
                        $total_amount = substr_count($comment, PHP_EOL) + 1;
                        $amount = $total_amount;
                    }
                }
            }
            if($row['type'] == 'Package'){
                $amount = 1;
            }
            $total = (int)$amount * $row['price'];
            $total = $total - $total * $ck / 100;
            die(json_encode([
                'status'        => 'success',
                'total'         => format_currency($total),
                'type'          => $row['type'],
                'min_max'       => __('Min').' '.format_cash($row['min']).' - '.__('Max').' '.format_cash($row['max']),
                'msg'           => isset($row['note']) ? $row['note'] : ''
            ]));
        }
    }

    
    if($store == 'accounts'){
        if (empty($_POST['amount'])) {
            die(format_currency(0));
        }
        
        // Validate token
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(__('Vui lòng đăng nhập'));
        }
        
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ?", [$token])) {
            die(__('Vui lòng đăng nhập'));
        }
        
        // Validate product ID
        $product_id = validate_int($_POST['id'], 1);
        if ($product_id === false) {
            die(format_currency(0));
        }
        
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `products` WHERE `id` = ?", [$product_id])) {
            $amount = validate_float($_POST['amount'], 0.01);
            if ($amount === false) {
                die(format_currency(0));
            }
            
            $total = $amount * $row['price'];
            $total = $total - $total * getDiscount($amount, $product_id) / 100;
            $total = $total - $total * $getUser['chietkhau'] / 100;
            
            if (isset($_POST['coupon'])) {
                $coupon_code = validate_alphanumeric($_POST['coupon']);
                if ($coupon_code !== false) {
                    $discount = checkCoupon($coupon_code, $getUser['id'], $total);
                }
            }
            if (isset($discount)) {
                $total = $total - $total * $discount / 100;
            }
            die(format_currency($total));
        }
        die(format_currency(0));
    }

    if($store == 'documents'){
        // Validate token
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(__('Vui lòng đăng nhập'));
        }
        
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ?", [$token])) {
            die(__('Vui lòng đăng nhập'));
        }
        
        // Validate document ID
        $document_id = validate_int($_POST['id'], 1);
        if ($document_id === false) {
            die(format_currency(0));
        }
        
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `documents` WHERE `id` = ?", [$document_id])) {
            $amount = 1;
            $total = $amount * $row['price'];
            $total = $total - $total * $getUser['chietkhau'] / 100;
            
            if (isset($_POST['coupon'])) {
                $coupon_code = validate_alphanumeric($_POST['coupon']);
                if ($coupon_code !== false) {
                    $discount = checkCoupon($coupon_code, $getUser['id'], $total);
                }
            }
            if (isset($discount)) {
                $total = $total - $total * $discount / 100;
            }
            die(format_currency($total));
        }
        die(format_currency(0));
    }

    if($store == 'store-fanpage'){
        // Validate token
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(__('Vui lòng đăng nhập'));
        }
        
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ?", [$token])) {
            die(__('Vui lòng đăng nhập'));
        }
        
        // Validate fanpage ID
        $fanpage_id = validate_int($_POST['id'], 1);
        if ($fanpage_id === false) {
            die(format_currency(0));
        }
        
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `store_fanpage` WHERE `id` = ?", [$fanpage_id])) {
            $amount = 1;
            $total = $amount * $row['price'];
            $total = $total - $total * $getUser['chietkhau'] / 100;
            
            if (isset($_POST['coupon'])) {
                $coupon_code = validate_alphanumeric($_POST['coupon']);
                if ($coupon_code !== false) {
                    $discount = checkCoupon($coupon_code, $getUser['id'], $total);
                }
            }
            if (isset($discount)) {
                $total = $total - $total * $discount / 100;
            }
            die(format_currency($total));
        }
        die(format_currency(0));
    }

 


    die(format_currency(0));
    
}
die(format_currency(0));
