<?php

define("IN_SITE", true);
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/lang.php");
require_once(__DIR__."/../../libs/helper.php");
$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['rating_data'])) {
        if ($CMSNT->site('status_demo') != 0) {
            die(json_encode(['status' => 'error', 'msg' => 'Bạn không được dùng chức năng này vì đây là trang web demo']));
        }
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? ", [$token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $order_id = validate_int($_POST['order_id'], 1);
        if ($order_id === false) {
            die(json_encode(['status' => 'error', 'msg' => __('ID đơn hàng không hợp lệ')]));
        }
        if(!$order = $CMSNT->get_row_safe(" SELECT * FROM `orders` WHERE `id` = ? AND `buyer` = ? ", [$order_id, $getUser['id']])) {
            die(json_encode(['status' => 'error', 'msg' => __('Bạn không có quyền đánh giá đơn hàng này')]));
        }
        if ($row = $CMSNT->get_row_safe("SELECT * FROM `reviews` WHERE `user_id` = ? AND `order_id` = ? ", [$getUser['id'], $order_id])) {
            die(json_encode(['status' => 'error', 'msg' => __('Bạn đã đánh giá đơn hàng này rồi')]));
        }
        if ($order['pay'] < $CMSNT->site('min_rating')) {
            die(json_encode(['status' => 'error', 'msg' => __('Bạn không đủ điều kiện đánh giá đơn hàng này')]));
        }
        $rating = validate_int($_POST['rating_data'], 1, 5);
        if ($rating === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Số sao đánh giá không hợp lệ (1-5)')]));
        }
        $review_text = validate_string($_POST['user_review'], 1000);
        if(isset($_POST['product_id'])){
            $product_id = validate_int($_POST['product_id'], 1);
            if ($product_id === false) {
                die(json_encode(['status' => 'error', 'msg' => __('ID sản phẩm không hợp lệ')]));
            }
            $isInsert = $CMSNT->insert("reviews", [
                'product_id'        =>  $product_id,
                'order_id'          =>  $order_id,
                'user_id'		    =>	$getUser['id'],
                'rating'		    =>	$rating,
                'review'		    =>	$review_text ?: '',
                'datetime'			=>	time()
            ]);
        }
        else if(isset($_POST['document_id'])){
            $document_id = validate_int($_POST['document_id'], 1);
            if ($document_id === false) {
                die(json_encode(['status' => 'error', 'msg' => __('ID tài liệu không hợp lệ')]));
            }
            $isInsert = $CMSNT->insert("reviews", [
                'document_id'       =>  $document_id,
                'order_id'          =>  $order_id,
                'user_id'		    =>	$getUser['id'],
                'rating'		    =>	$rating,
                'review'		    =>	$review_text ?: '',
                'datetime'			=>	time()
            ]);
        }
        if ($isInsert) {
            die(json_encode(['status' => 'success', 'msg' => __('Gửi đánh giá thành công')]));
        } else {
            die(json_encode(['status' => 'error', 'msg' => __('Gửi đánh giá thất bại')]));
        }
    }

    if (isset($_POST["action"])) {
        $average_rating = 0;
        $total_review = 0;
        $five_star_review = 0;
        $four_star_review = 0;
        $three_star_review = 0;
        $two_star_review = 0;
        $one_star_review = 0;
        $total_user_rating = 0;
        $review_content = array();
        $product_id = validate_int($_POST['product_id'], 1);
        if ($product_id === false) {
            die(json_encode(['status' => 'error', 'msg' => __('ID sản phẩm không hợp lệ')]));
        }
        foreach ($CMSNT->get_list_safe("SELECT * FROM `reviews` WHERE `product_id` = ? ORDER BY id DESC ", [$product_id]) as $row) {
            $review_content[] = array(
                'user_name'		=>	substr(getRowRealtime("users", $row['user_id'], "username"), 0, 2).'****',
                'review'        =>	$row["review"],
                'rating'		=>	$row["rating"],
                'datetime'		=>	timeAgo($row['datetime'])
            );
            if ($row["rating"] == '5') {
                $five_star_review++;
            }
            if ($row["rating"] == '4') {
                $four_star_review++;
            }
            if ($row["rating"] == '3') {
                $three_star_review++;
            }
            if ($row["rating"] == '2') {
                $two_star_review++;
            }
            if ($row["rating"] == '1') {
                $one_star_review++;
            }
            $total_review++;
            $total_user_rating = $total_user_rating + $row["rating"];
        }
        $average_rating = $total_user_rating / $total_review;
        $output = array(
            'average_rating'	=>	$average_rating,
            'total_review'		=>	$total_review,
            'five_star_review'	=>	$five_star_review,
            'four_star_review'	=>	$four_star_review,
            'three_star_review'	=>	$three_star_review,
            'two_star_review'	=>	$two_star_review,
            'one_star_review'	=>	$one_star_review,
            'review_data'		=>	$review_content
        );
        die(json_encode($output));
    }

    if (isset($_POST['profile_ctv'])) {
        $average_rating = 0;
        $total_review = 0;
        $five_star_review = 0;
        $four_star_review = 0;
        $three_star_review = 0;
        $two_star_review = 0;
        $one_star_review = 0;
        $total_user_rating = 0;
        $review_content = array();
        $user_id = validate_int($_POST['user_id'], 1);
        if ($user_id === false) {
            die(json_encode(['status' => 'error', 'msg' => __('ID người dùng không hợp lệ')]));
        }
        foreach ($CMSNT->get_list_safe("SELECT * FROM `reviews` WHERE `user_id` = ? ORDER BY id DESC ", [$user_id]) as $row) {
            $review_content[] = array(
                'user_name'		=>	substr(getRowRealtime("users", $row['user_id'], "username"), 0, 2).'*****',
                'product_name'  =>  getRowRealtime("products", $row['product_id'], 'name'),
                'review'        =>	$row["review"],
                'rating'		=>	$row["rating"],
                'datetime'		=>	timeAgo($row['datetime'])
            );
            if ($row["rating"] == '5') {
                $five_star_review++;
            }
            if ($row["rating"] == '4') {
                $four_star_review++;
            }
            if ($row["rating"] == '3') {
                $three_star_review++;
            }
            if ($row["rating"] == '2') {
                $two_star_review++;
            }
            if ($row["rating"] == '1') {
                $one_star_review++;
            }
            $total_review++;
            $total_user_rating = $total_user_rating + $row["rating"];
        }
        $average_rating = $total_user_rating / $total_review;
        $output = array(
            'average_rating'	=>	number_format($average_rating, 1),
            'total_review'		=>	$total_review,
            'five_star_review'	=>	$five_star_review,
            'four_star_review'	=>	$four_star_review,
            'three_star_review'	=>	$three_star_review,
            'two_star_review'	=>	$two_star_review,
            'one_star_review'	=>	$one_star_review,
            'review_data'		=>	$review_content
        );
        die(json_encode($output));
    }
}
