<?php

define("IN_SITE", true);
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
require_once(__DIR__."/../../libs/lang.php");
require_once(__DIR__."/../../libs/sendEmail.php");
$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();
use PragmaRX\Google2FAQRCode\Google2FA;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($CMSNT->site('status') != 1 && isSecureCookie('admin_login') != true) {
        die(json_encode(['status' => 'error', 'msg' => __('Hệ thống đang bảo trì') ]));
    }
    if (isset($_POST['action']) && $_POST['action'] == 'ChangeProfile') {
        if ($CMSNT->site('status_demo') != 0) {
            $data = json_encode([
                'status'    => 'error',
                'msg'       => 'Không được dùng chức năng này vì đây là trang web demo'
            ]);
            die($data);
        }
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? ", [$token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $fullname = !empty($_POST['fullname']) ? validate_string($_POST['fullname'], 255) : null;
        $phone = !empty($_POST['phone']) ? validate_phone($_POST['phone']) : null;
        if ($phone === false && !empty($_POST['phone'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Số điện thoại không hợp lệ')]));
        }
        $isUpdate = $CMSNT->update("users", [
            'fullname' => $fullname,
            'phone' => $phone
        ], " `token` = ? ", [$token]);
        if ($isUpdate) {
            $CMSNT->insert("logs", [
                'user_id'       => $getUser['id'],
                'ip'            => myip(),
                'device'        => $Mobile_Detect->getUserAgent(),
                'createdate'    => gettime(),
                'action'        => __('Thay đổi thông tin hồ sơ')
            ]);
            die(json_encode(['status' => 'success', 'msg' => __('Lưu thành công')]));
        }
        die(json_encode(['status' => 'error', 'msg' => __('Lưu thất bại')]));
    }


    if (isset($_POST['action']) && $_POST['action'] == 'ChangePassword') {
        if ($CMSNT->site('status_demo') != 0) {
            $data = json_encode([
                'status'    => 'error',
                'msg'       => 'Không được dùng chức năng này vì đây là trang web demo'
            ]);
            die($data);
        }
        if (empty($_POST['token'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? ", [$token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        if (empty($_POST['password'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập mật khẩu hiện tại')]));
        }
        if (empty($_POST['newpassword'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập mật khẩu mới')]));
        }
        if (empty($_POST['renewpassword'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Nhập lại mật khẩu không đúng')]));
        }
        if ($_POST['renewpassword'] != $_POST['newpassword']) {
            die(json_encode(['status' => 'error', 'msg' => __('Nhập lại mật khẩu không đúng')]));
        }
        $password = validate_string($_POST['password'], 255, 1);
        if ($password === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Mật khẩu không hợp lệ')]));
        }
        if ($CMSNT->site('type_password') == 'bcrypt') {
            if (!password_verify($password, $getUser['password'])) {
                die(json_encode(['status' => 'error', 'msg' => __('Mật khẩu hiện tại không chính xác')]));
            }
        } else {
            if ($getUser['password'] != TypePassword($password)) {
                die(json_encode(['status' => 'error', 'msg' => __('Mật khẩu hiện tại không chính xác')]));
            }
        }
        $newpassword = validate_string($_POST['newpassword'], 255, 6);
        if ($newpassword === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Mật khẩu mới không hợp lệ (tối thiểu 6 ký tự)')]));
        }
        $isUpdate = $CMSNT->update("users", [
            'change_password'   => 1,
            'password'  => TypePassword($newpassword),
            'token'     => generateUltraSecureToken()
        ], " `token` = ? ", [$token]);
        if ($isUpdate) {
            $CMSNT->insert("logs", [
                'user_id'       => $getUser['id'],
                'ip'            => myip(),
                'device'        => $Mobile_Detect->getUserAgent(),
                'createdate'    => gettime(),
                'action'        => __('Thay đổi mật khẩu')
            ]);
            die(json_encode(['status' => 'success', 'msg' => __('Đổi mật khẩu thành công')]));
        }
        die(json_encode(['status' => 'error', 'msg' => __('Đổi mật khẩu thất bại')]));
    }

    if (isset($_POST['action']) && $_POST['action'] == 'ChangeGoogle2FA') {
        if ($CMSNT->site('status_demo') != 0) {
            $data = json_encode([
                'status'    => 'error',
                'msg'       => 'Không được dùng chức năng này vì đây là trang web demo'
            ]);
            die($data);
        }
        if (empty($_POST['token'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? ", [$token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        if (empty($_POST['secret'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập mã xác minh 2FA')]));
        }
        $secret = validate_alphanumeric($_POST['secret'], 10);
        if ($secret === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Mã xác minh không hợp lệ')]));
        }
        $google2fa = new Google2FA();
        if ($google2fa->verifyKey($getUser['SecretKey_2fa'], $secret, 2) != true) {
            die(json_encode(['status' => 'error', 'msg' => __('Mã xác minh không chính xác')]));
        }
        $status_2fa = validate_int($_POST['status_2fa'], 0, 1);
        if ($status_2fa === false) {
            $status_2fa = 0;
        }
        $isUpdate = $CMSNT->update("users", [
            'status_2fa' => $status_2fa
        ], " `token` = ? ", [$token]);
        if ($isUpdate) {
            $CMSNT->insert("logs", [
                'user_id'       => $getUser['id'],
                'ip'            => myip(),
                'device'        => $Mobile_Detect->getUserAgent(),
                'createdate'    => gettime(),
                'action'        => __('Thay đổi trạng thái Google 2FA')
            ]);
            die(json_encode(['status' => 'success', 'msg' => __('Lưu thành công')]));
        }
        die(json_encode(['status' => 'error', 'msg' => __('Lưu thất bại')]));
    }

    if (isset($_POST['action']) && $_POST['action'] == 'VerifyGoogle2FA') {
        if (empty($_POST['token'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $token_2fa = validate_alphanumeric($_POST['token']);
        if ($token_2fa === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token_2fa` = ? ", [$token_2fa])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        if (empty($_POST['code'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập mã xác minh')]));
        }
        if($getUser['limit_2fa'] >= 5){
            $CMSNT->update("users", [
                'limit_2fa' => 0,
                'token_2fa' => NULL
            ], " `id` = ? ", [$getUser['id']]);
            // banned ip nếu sai 2fa quá 5 lần
            $CMSNT->insert('banned_ips', [
                'ip'                => myip(),
                'attempts'          => $getUser['limit_2fa'],
                'create_gettime'    => gettime(),
                'banned'            => 1,
                'reason'            => 'Input the wrong 2FA code many times'
            ]);
            die(json_encode(['status' => 'error', 'msg' => __('Bạn đã nhập sai quá nhiều lần, vui lòng xác minh lại từ đầu')]));
        }
        $code = validate_alphanumeric($_POST['code'], 10);
        if ($code === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Mã xác minh không hợp lệ')]));
        }
        $google2fa = new Google2FA();
        if ($google2fa->verifyKey($getUser['SecretKey_2fa'], $code, 2) != true) {
            $CMSNT->insert("logs", [
                'user_id'       => $getUser['id'],
                'ip'            => myip(),
                'device'        => $Mobile_Detect->getUserAgent(),
                'createdate'    => gettime(),
                'action'        => '[Warning] Phát hiện có người đang cố gắng nhập mã xác minh 2FA'
            ]);
            $CMSNT->cong('users', 'limit_2fa', 1, " `id` = ? ", [$getUser['id']]);
            die(json_encode(['status' => 'error', 'msg' => __('Mã xác minh không chính xác')]));
        }
        $CMSNT->insert("logs", [
            'user_id'       => $getUser['id'],
            'ip'            => myip(),
            'device'        => $Mobile_Detect->getUserAgent(),
            'createdate'    => gettime(),
            'action'        => __('Đăng nhập thành công vào hệ thống')
        ]);
        $CMSNT->update("users", [
            'token_2fa' => NULL,
            'ip' => myip(),
            'time_session' => time(),
            'device' => $Mobile_Detect->getUserAgent()
        ], " `id` = ? ", [$getUser['id']]);
        $Mobile_Detect = new Mobile_Detect();

        // Lưu đăng nhập vào Cookie
        setSecureCookie('user_login', $getUser['token']);
        setSecureCookie('user_agent', $Mobile_Detect->getUserAgent());

        if($getUser['admin'] > 0){
            setSecureCookie('admin_login', $getUser['token']);
        }
        // Login CTV
        if($getUser['ctv'] > 0){
            setSecureCookie('ctv_login', $getUser['token']);
        }
        die(json_encode([
            'status' => 'success',
            'msg'    => __('Đăng nhập thành công')
        ]));
    }

    if (isset($_POST['action']) && $_POST['action'] == 'VerifyOTPMail') {
        if (empty($_POST['token'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        $otp_token = validate_alphanumeric($_POST['token']);
        if ($otp_token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `otp_token` = ? ", [$otp_token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        if (empty($_POST['code'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập mã xác minh')]));
        }
        if ($getUser['otp'] == NULL) {
            die(json_encode(['status' => 'error', 'msg' => __('OTP không đúng')]));
        }
        if($getUser['otp_limit'] >= 5){
            $CMSNT->update("users", [
                'otp' => NULL,
                'otp_limit' => 0,
                'otp_token' => NULL
            ], " `id` = ? ", [$getUser['id']]);
            // banned ip nếu sai otp quá 5 lần
            $CMSNT->insert('banned_ips', [
                'ip'                => myip(),
                'attempts'          => $getUser['otp_limit'],
                'create_gettime'    => gettime(),
                'banned'            => 1,
                'reason'            => 'Input the wrong OTP Mail code many times'
            ]);
            die(json_encode(['status' => 'error', 'msg' => __('Bạn đã nhập sai quá nhiều lần, vui lòng xác minh lại từ đầu')]));
        }
        $otp_code = validate_alphanumeric($_POST['code'], 10);
        if ($otp_code === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Mã OTP không hợp lệ')]));
        }
        if ($getUser['otp'] != $otp_code) {
            $CMSNT->insert("logs", [
                'user_id'       => $getUser['id'],
                'ip'            => myip(),
                'device'        => $Mobile_Detect->getUserAgent(),
                'createdate'    => gettime(),
                'action'        => '[Warning] Phát hiện có người đang cố gắng nhập OTP Mail'
            ]);
            $CMSNT->cong('users', 'otp_limit', 1, " `id` = ? ", [$getUser['id']]);
            die(json_encode(['status' => 'error', 'msg' => __('OTP không đúng')]));
        }
        $CMSNT->insert("logs", [
            'user_id'       => $getUser['id'],
            'ip'            => myip(),
            'device'        => $Mobile_Detect->getUserAgent(),
            'createdate'    => gettime(),
            'action'        => __('Đăng nhập thành công vào hệ thống')
        ]);
        $CMSNT->update("users", [
            'otp' => NULL,
            'otp_limit' => 0,
            'otp_token' => NULL,
            'ip' => myip(),
            'time_session' => time(),
            'device' => $Mobile_Detect->getUserAgent()
        ], " `id` = ? ", [$getUser['id']]);
        
        // Lưu đăng nhập vào Cookie
        setSecureCookie('user_login', $getUser['token']);
        setSecureCookie('user_agent', $Mobile_Detect->getUserAgent());

        if($getUser['admin'] > 0){
            setSecureCookie('admin_login', $getUser['token']);
        }
        if($getUser['ctv'] > 0){
            setSecureCookie('ctv_login', $getUser['token']);
        }
        die(json_encode([
            'status' => 'success',
            'msg'    => __('Đăng nhập thành công')
        ]));
    }


}
