<?php

define("IN_SITE", true);
require_once(__DIR__."/../../config.php");
require_once(__DIR__."/../../libs/lang.php");
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");

$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();
use PragmaRX\Google2FAQRCode\Google2FA;


if (isset($_POST['action'])) {
    if ($CMSNT->site('status') != 1 && isSecureCookie('admin_login') != true) {
        die(json_encode(['status' => 'error', 'msg' => __('Hệ thống đang bảo trì định kỳ, vui lòng quay lại sau !')]));
    }

    if($_POST['action'] == 'add-create-website'){
        $token = validate_alphanumeric($_POST['token']);
        if ($token === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Token không hợp lệ')]));
        }
        if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? AND `banned` = 0 ", [$token])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng đăng nhập')]));
        }
        if (time() - $getUser['time_request'] < $config['max_time_load']) {
            die(json_encode(['status' => 'error', 'msg' => __('Bạn đang thao tác quá nhanh, vui lòng chờ')]));
        }
        $domain = validate_string($_POST['domain'], 255, 3);
        if ($domain === false) {
            die(json_encode(['status' => 'error', 'msg' => __('Tên miền không hợp lệ')]));
        }
        if(is_valid_domain_name($domain) != true){
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập tên miền hợp lệ')]));
        }
        if(strpos($domain, '.') == false){
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng nhập tên miền hợp lệ')]));
        }
        $domain_check = $CMSNT->get_row_safe(" SELECT COUNT(id) as count FROM `domains` WHERE `domain` = ? ", [$domain]);
        if($domain_check['count'] > 0){
            die(json_encode(['status' => 'error', 'msg' => __('Tên miền này đã tồn tại trong hệ thống')]));
        }
        $isInsert = $CMSNT->insert('domains', [
            'user_id'           => $getUser['id'],
            'domain'            => $domain,
            'status'            => 0,
            'create_gettime'    => gettime(),
            'update_gettime'    => gettime()
        ]);
        if($isInsert){
            /** SEND NOTI CHO ADMIN */
            $my_text = $CMSNT->site('create_website_notification');
            $my_text = str_replace('{domain}', $_SERVER['SERVER_NAME'], $my_text);
            $my_text = str_replace('{username}', $getUser['username'], $my_text);
            $my_text = str_replace('{url}', $domain, $my_text);
            $my_text = str_replace('{time}', gettime(), $my_text);
            sendMessAdmin($my_text);
            die(json_encode(['status' => 'success', 'msg' => __('Thêm tên miền thành công, vui lòng chờ Admin xử lý')]));
        }
    }

   
    
}
